from libdebug import debugger
from string import ascii_letters, digits

d = debugger("main", escape_antidebug=True)

alphabet = ascii_letters + digits + "_{}"

for c in alphabet:
    r = d.run()
    bp = d.breakpoint(0x13e1, hardware=True, file="binary")
    d.cont()

    r.sendline(c.encode())

    d.wait()
    
    d.kill()

    print(c, bp.hit_count)

    if bp.hit_count > 0:
        print('Found:', c)
        break